library(readxl)
data = read_excel("DataSets.xlsx", sheet = "z_t_test", range = "B4:C24")

head(data)
t.test(data$wts)
summary(data$wts)
mean(data$wts)
sd(data$wts)

n = length(data$wts)
sd = sd(data$wts)
se = sd/sqrt(n)
se

ll = mean(data$wts) - se*1.96
up = mean(data$wts) + se*1.96

c(ll, up)


# install.packages('pacman')
pacman::p_load(readxl, car, jtools, agricolae, tidyverse)
data = read_excel("DataSets.xlsx", sheet = "z_t_test", range = "B4:C24")
# piping
data %>% select(wts) %>% t.test()
t.test(data$wts)

boxplot(data$wts)
qqPlot(data$wts)
shapiro.test(data$wts)
# H0: Distribution is normal

# p > 0.05, sufficient evidence to support the H0, so H0 could not be rejected

# ggplot
ggplot(data) +
  aes(y = wts) +
  geom_boxplot(fill = 'red') +
  labs(x = "Variable",
       y = "Weight (g)") +
  theme_test()

  

